<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class COwlCarousel extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"carousel"		 => "carousel.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($slider , $widget = false) {
		global $_LANG_ID , $base , $_LANG_RAW;
		$this->__init();


		if (!is_array($slider)) {
			$slider = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:owlcarousel']},
					{$this->tables['plugin:sliders']}

				WHERE 
					slider_module LIKE '{$this->name}' AND 
					owl_id = slider_sid AND 
					slider_status = 1 AND 
					owl_id='{$slider}'"
			);
		}

		if (!is_Array($slider)) {
			return "";
		}
		
	
		$slider["widget"] = $widget;

		$slider["lang_id"] = $_LANG_ID;

		$slider["rtl"] = $_LANG_RAW["lang_dir"] == "rtl" ? "true" : "false";

		return $this->slider($slider);
		
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function slider($slider) {
		global $base;

		$template = &$this->private->templates["carousel"];


		$slides = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:owlcarousel_slides']}
			WHERE 
				slide_slider = {$slider['owl_id']} 
			ORDER BY 
				slide_order ASC
			"
		);

		if (is_array($slides)) {

			
			//process slides
			foreach ($slides as $key => $slide) {

				switch ($slide["slide_type"]) {
					case "1":	

						$slide["over"] = $slide["slide_image_html"] ? $template->blockReplace("OverHtml", $slide) : "";

						if ($slide["slide_link_type"]) {

							$slide["link"] = $this->plugins["modules"]->BuildLink(array(
								"type"	=> $slide["slide_link_type"],
								"link"	=> $slide["slide_link_link"],
								"module"=> $slide["slide_link_module"],
								"global"=> $slide["slide_link_global"]
							));

							
							$slides[$key]["content"] = $template->blockReplace("TypeLinkImage"	, $slide);	
						} else {						
							$slides[$key]["content"] = $template->blockReplace("TypeImage"	, $slide);	
						}

					break;
					case "2": $slides[$key]["content"] = $template->blockReplace("TypeYoutube"	, $slide);	break;
					case "3": $slides[$key]["content"] = $template->blockReplace("TypeVimeo"	, $slide);	break;
					case "4": $slides[$key]["content"] = $template->blockReplace("TypeHtml"		, $slide);	break;
				}				

				
				$slides[$key]["overlay"] = $slide["slide_overlay"] ? $this->plugins["skineditor"]->Overlay($slide["slide_overlay"]): "";
			}	


			
			
			return $template->blockReplace(
				$slider["widget"] ? "Widget" : "Main" ,			
				array(
					"slider"	=> $base->html->Table(
						$template , 
						"" , 
						$slides
					),
					"script"	=> $template->blockReplace(
						"Script" , 
						array(
							"items"		=> $slider["owl_data_items"],
							"margin"	=> $slider["owl_data_margin"],
							"loop"		=> $this->BoolVar($slider["owl_data_loop"]),
							"nav"		=> $this->BoolVar($slider["owl_data_nav"]),
							"navtext"	=> $slider["owl_data_navtext"],
							"navrewind"	=> $this->BoolVar($slider["owl_data_navrewind"]),
							"dots"		=> $this->BoolVar($slider["owl_data_dots"]),
							"autowidth"	=> $this->BoolVar($slider["owl_data_autowidth"]),
							"dotseach"	=> (int)$slider["owl_data_dots_each"],
							"lazyload"	=> $this->BoolVar($slider["owl_data_lazy"]),
							"center"	=> $this->BoolVar($slider["owl_data_center"]),
							"autoplay"	=> $this->BoolVar($slider["owl_data_autoplay"]),
							"mousedrag"	=> $this->BoolVar($slider["owl_data_mousedrag"]),
							"touchdrag"	=> $this->BoolVar($slider["owl_data_touchdrag"]),
							"pulldrag"	=> $this->BoolVar($slider["owl_data_pulldrag"]),
							"freedrag"	=> $this->BoolVar($slider["owl_data_freedrag"]),
							"autoplaytimeout"	=> $slider["owl_data_autoplay_timeout"],
							"autoplayhoverpause"=> $this->BoolVar($slider["owl_data_autoplay_hoverpause"]),
							"video"			=> $this->BoolVar($slider["owl_data_video"]),
							"autoheight"	=> $this->BoolVar($slider["owl_data_autoheight"]),
							"stagepadding"	=> $slider["owl_data_stagepadding"],
							"slideby"		=> $slider["owl_data_slideby"],
							"videowidth"	=> $slider["owl_data_videowidth"],
							"videoheight"	=> $slider["owl_data_videoheight"],
							"animateout"	=> $this->Animation($slider["owl_data_animateout"]),
							"animatein"		=> $this->Animation($slider["owl_data_animatein"]),

						)
					),
				),
				$slider
			);		

		}		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function BoolVar($value) {
		if ($value == "1") {
			return "true";
		} elseif ($value == "0") {
			return "false";
		} else {
			return $value;
		}
		
	}
	


	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Remove() {
		global $_TSM;

		$_TSM["PUB:SLIDER"] = "";
		$this->removed = true;
	}
	

	function ShortCode($matches) {
		return $this->Render($matches[1]);
	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Animation($data) {

		$animations = array(
			"bounce"	=> "bounce",
			"flash"	=> "flash",
			"pulse"	=> "pulse",
			"rubberband"	=> "rubberBand",
			"shake"	=> "shake",
			"swing"	=> "swing",
			"tada"	=> "tada",
			"wobble"	=> "wobble",
			"bouncein"	=> "bounceIn",
			"bounceindown"	=> "bounceInDown",
			"bounceinleft"	=> "bounceInLeft",
			"bounceinright"	=> "bounceInRight",
			"bounceinup"	=> "bounceInUp",
			"bounceout"	=> "bounceOut",
			"bounceoutdown"	=> "bounceOutDown",
			"bounceoutleft"	=> "bounceOutLeft",
			"bounceoutright"	=> "bounceOutRight",
			"bounceoutup"	=> "bounceOutUp",
			"fadein"	=> "fadeIn",
			"fadeindown"	=> "fadeInDown",
			"fadeindownbig"	=> "fadeInDownBig",
			"fadeinleft"	=> "fadeInLeft",
			"fadeinleftbig"	=> "fadeInLeftBig",
			"fadeinright"	=> "fadeInRight",
			"fadeinrightbig"	=> "fadeInRightBig",
			"fadeinup"	=> "fadeInUp",
			"fadeinupbig"	=> "fadeInUpBig",
			"fadeout"	=> "fadeOut",
			"fadeoutdown"	=> "fadeOutDown",
			"fadeoutdownbig"	=> "fadeOutDownBig",
			"fadeoutleft"	=> "fadeOutLeft",
			"fadeoutleftbig"	=> "fadeOutLeftBig",
			"fadeoutright"	=> "fadeOutRight",
			"fadeoutrightbig"	=> "fadeOutRightBig",
			"fadeoutup"	=> "fadeOutUp",
			"fadeoutupbig"	=> "fadeOutUpBig",
			"flipinx"	=> "flipInX",
			"flipiny"	=> "flipInY",
			"flipoutx"	=> "flipOutX",
			"flipouty"	=> "flipOutY",
			"lightspeedin"	=> "lightSpeedIn",
			"lightspeedout"	=> "lightSpeedOut",
			"rotatein"	=> "rotateIn",
			"rotateindownleft"	=> "rotateInDownLeft",
			"rotateindownright"	=> "rotateInDownRight",
			"rotateinupleft"	=> "rotateInUpLeft",
			"rotateinupright"	=> "rotateInUpRight",
			"rotateout"	=> "rotateOut",
			"rotateoutdownleft"	=> "rotateOutDownLeft",
			"rotateoutdownright"	=> "rotateOutDownRight",
			"rotateoutupleft"	=> "rotateOutUpLeft",
			"rotateoutupright"	=> "rotateOutUpRight",
			"hinge"	=> "hinge",
			"rollin"	=> "rollIn",
			"rollout"	=> "rollOut",
			"zoomin"	=> "zoomIn",
			"zoomindown"	=> "zoomInDown",
			"zoominleft"	=> "zoomInLeft",
			"zoominright"	=> "zoomInRight",
			"zoominup"	=> "zoomInUp",
			"zoomout"	=> "zoomOut",
			"zoomoutdown"	=> "zoomOutDown",
			"zoomoutleft"	=> "zoomOutLeft",
			"zoomoutright"	=> "zoomOutRight",
			"zoomoutup"	=> "zoomOutUp",
			"slideindown"	=> "slideInDown",
			"slideinleft"	=> "slideInLeft",
			"slideinright"	=> "slideInRight",
			"slideinup"	=> "slideInUp",
			"slideoutdown"	=> "slideOutDown",
			"slideoutleft"	=> "slideOutLeft",
			"slideoutright"	=> "slideOutRight",
			"slideoutup"	=> "slideOutUp"
		);

		return $animations[strtolower($data)];

	}
	
}

?>